<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use common\models\Groups;

/* @var $this yii\web\View */
/* @var $model backend\models\Admin */
/* @var $form yii\widgets\ActiveForm */
$data = ArrayHelper::map(Groups::find()->asArray()->all(), 'group', 'group');
$model->groups =  json_decode($model->groups); // initial value

?>

<div class="admin-form special-form-modal">

    <?php $form = ActiveForm::begin(); ?>

    <?php if(Yii::$app->user->identity->role == \backend\models\Admin::ROLE_SUPER_ADMIN){ ?>

    <?= $form->field($model, 'login')->textInput(['maxlength' => true]) ?>

    <?php } ?>

    <?= $form->field($model, 'new_password')->passwordInput() ?>

    <?= $form->field($model, 'confirm_password')->passwordInput() ?>

    <?php if(Yii::$app->user->identity->role == \backend\models\Admin::ROLE_SUPER_ADMIN){ ?>

    <?= $form->field($model, 'role')->widget(Select2::classname(), [
        'data' => [
            '10' => 'QA (Quality Assurance)',
            '20' => 'Superadmin',
            ],
        ]) ?>

    <?= $form->field($model, 'groups')->widget(Select2::classname(), [
            'data' => $data,
            'options' => ['placeholder' => 'Select groups ...', 'multiple' => true],
            'pluginOptions' => [
                'tags' => true,
                'tokenSeparators' => [',', ' '],
                'maximumInputLength' => 10,
                'maintainOrder' => true
            ],
        ])->label('Access to groups'); ?>

    <?= $form->field($model, 'status')->widget(Select2::classname(), [
            'data' => [
                '0' => 'Inactive',
                '1' => 'Active',
            ],
        ]); ?>

    <?php } ?>

	<?php if (!Yii::$app->request->isAjax){ ?>
	  	<div class="form-group">
	        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => 'btn btn-primary  btn-bright']) ?>
	    </div>
	<?php } ?>

    <?php ActiveForm::end(); ?>
    
</div>
